#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Fast Minimal Animated BlocksMod01.fsh    by   Shane 
//https://www.shadertoy.com/view/MlVXzd
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
uniform vec4  iDate; 

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*

	Fast, Minimal Animated Blocks
	-----------------------------

	Emulating the Voronoi triangle metric - the one that looks like blocks - with 
    wrappable, rotated tiles. 

	I've slimmed the code down a little bit, but mainly to get the point across that 
    this approach requires far fewer instructions than the regular random-offset-point 
    grid setup. The main purpose of the exercise was efficiency... and to a lesser 
    degree, novelty. :)

	For an instruction count comparison, take a look at a few of the Voronoi block (or 
	standard) Voronoi examples on here.

	Relevant Examples:
	
	// About as minimal as it gets. Whoever made this had way too much time on his hands. :D
	One Tweet Cellular Pattern - Shane
	https://www.shadertoy.com/view/MdKXDD

    // Awesome. Also good for an instruction count comparison.
	Blocks -IQ
    https://www.shadertoy.com/view/lsSGRc

    // Similar code size, but very different instruction count.
    Triangular Voronoi Lighted - Aiekick
	https://www.shadertoy.com/view/ltK3WD

*/

// Distance metric. A slightly rounded triangle is being used, but the usual distance
// metrics all work.
float s(vec2 p){
    
    p = fract(p) - .5;   
    //return max(abs(p.x)*.866 + p.y*.5, -p.y); // Regular triangle.
    //return (length(p)*1.5 + .25)*max(abs(p.x)*.866 + p.y*.5, -p.y);
    return (dot(p, p)*2. + .5)*max(abs(p.x)*.866 + p.y*.5, -p.y);
    //return dot(p, p)*2.;
    //return length(p);
    //return max(abs(p.x), abs(p.y)); // Etc.
    
    //return max(max(abs(p.x)*.866 + p.y*.5, -p.y), -max(abs(p.x)*.866 - p.y*.5, p.y) + .2);
}

// Very cheap wrappable cellular tiles. This one produces a block pattern on account of the
// metric used, but other metrics will produce the usual patterns.
//
// Construction is pretty simple: Plot two points in a wrappble cell and record their distance. 
// Rotate by a third of a circle then repeat ad infinitum. Unbelievably, just one rotation 
// is needed for a random looking pattern. Amazing... to me anyway. :)
//
// Note that there are no random points at all, no loops, and virtually no setup, yet the 
// pattern appears random anyway.
float m(vec2 p){    
    
    // Offset - used for animation. Put in as an afterthought, so probably needs more
    // tweaking, but it works well enough for the purpose of this demonstration.
    vec2 o = sin(vec2(1.93, 0) + iDate.w)*.166;
    
    // The distance to two wrappable, moving points.
    float a = s(p + vec2(o.x, 0)), b = s(p + vec2(0, .5 + o.y));
    
    // Rotate the layer (coordinates) by 120 degrees. 
    p = -mat2(.5, -.866, .866, .5)*(p + .5);
    // The distance to another two wrappable, moving points.
    float c = s(p + vec2(o.x, 0)), d = s(p + vec2(0, .5 + o.y)); 
    
    // Return the minimum distance among the four points. If adding the points below,
    // be sure to comment the following line out.
    //return min(min(a, b), min(c, d))*2.;
    
 
    // One more iteration. Gives an even more random pattern. With this, it's 
    // still a very cheap process. Be sure to comment out the return line above.
	
    // Rotate the layer (coordinates) by 120 degrees.
    p = -mat2(.5, -.866, .866, .5)*(p + .5);
    // The distance to yet another two wrappable, moving points.
    float e = s(p + vec2(o.x, 0)), f = s(p + vec2(0, .5 + o.y)); 

    // Return the minimum distance among the six points.
    return min(min(min(a, b), min(c, d)),  min(e, f))*2.;
  
    
}
#define o fragColor
#define p fragCoord
//void mainImage(out vec4 o, vec2 p){
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 	 
    // Screen coordinates.
    p /= iResolution.y/3.;
    
    // The function value.
    o = vec4(1)*m(p);

    // Cheap highlighting.
    vec4 b = vec4(.8, .5, 1, 0)*max(o - m(p + .01), 0.)/.05;
    
    
    // Colorize and add the highlighting.
    o = pow(vec4(1.5, 1, 1, 0)*o, vec4(1, 3.5, 16, 0))  + b*b*(.5 + b*b);
    
    
    // Applying a curvature based gradient to the surface to bring 
    // it out a bit more.
    #if 1
     
    // Height value.
    float h = m(p);
    
    // Taking four nearby offset samples to use for curvature calculations.
    vec2 e = vec2(.02*450./iResolution.y, 0); // Sample distance.

    vec4 t4 = vec4(m(p - e),  m(p + e), m(p - e.yx), m(p + e.yx));
    
    // Using the four samples above to calculate the surface curvature.
    float amp = 1.;
    float curv = clamp((h*4. - dot(t4, vec4(1)))/e.x/2.*amp + .5, 0., 1.);
    
    // Apply the curvature.
    o *= curv*1.5 + .5; // Light lines.
    //o = mix(o, o*o*.5, abs(curv - .5)*2.); // Dark lines.

    #endif
    
    // Rough gamma correction.
    fragColor = sqrt(max(o, 0.));
    
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

